import { createSlice, createAsyncThunk } from "@reduxjs/toolkit";
import { filterProductData } from "../../../screens/Home/FeatureDIsplay/filterProductData.js";
import { queryResponse } from "../util/processResponse.js";

const initialState = {
    searchProducts: [],
    filterable: {},
    filter_applied: {},
    loading: true,
    nextPageUrl: "",
    loadMore: false,
};
let postfix;
export const getsearchProducts = createAsyncThunk(
    "items/getsearchProducts",
    async (obj) => {
        const { access_token, URL } = obj;
        postfix = URL.split("?");
        postfix = `&${postfix.slice(1).join("&")}`;
        const res = await queryResponse(URL, "GET", access_token);
        return res;
    }
);
export const getMoreSearchProducts = createAsyncThunk(
    "items/getMoreSearchProducts",
    async (obj) => {
        const { access_token, URL } = obj;
        postfix = URL.split("&");
        if (postfix.length == 1) {
            postfix = URL.split("?");
        }
        postfix = `&${postfix.slice(1).join("&")}`;
        const res = await queryResponse(URL, "GET", access_token);
        return res;
    }
);

const searchProductsSlice = createSlice({
    name: "items",
    initialState,
    reducers: {
        resetSearchProduct: (state) => {
            state.searchProducts = [];
            state.filterable = {};
            state.filter_applied = {};
            state.loadMore = false;
            state.nextPageUrl = "";
            state.loading = true;
        },
    },
    extraReducers: (builder) => {
        builder.addCase(getsearchProducts.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(getsearchProducts.fulfilled, (state, { payload }) => {
            const {
                data = [],
                filterable,
                filter_applied,
                pagination: { next_page_url } = {},
            } = payload?.records || {};
            const { code } = payload?.status || {};
            if (code == 200) {
                let newData = filterProductData(data);
                state.searchProducts = newData;
                if (next_page_url && postfix) {
                    state.nextPageUrl = `${next_page_url}${postfix}`;
                } else {
                    state.nextPageUrl = next_page_url;
                }
                state.filterable = filterable;
                state.filter_applied = filter_applied;
            } else {
                state.searchProducts = state.searchProducts;
            }
            state.loading = false;
        });
        builder.addCase(getsearchProducts.rejected, (state) => {
            state.loading = false;
        });
        builder.addCase(getMoreSearchProducts.pending, (state) => {
            state.loadMore = true;
        });
        builder.addCase(
            getMoreSearchProducts.fulfilled,
            (state, { payload }) => {
                const {
                    data = [],
                    pagination: { next_page_url } = {},
                } = payload?.records || {};
                const { code } = payload?.status || {};
                if (code == 200) {
                    let newData = filterProductData(data);
                    state.searchProducts = [
                        ...state.searchProducts,
                        ...newData,
                    ];
                    if (next_page_url && postfix) {
                        state.nextPageUrl = `${next_page_url}${postfix}`;
                    } else {
                        state.nextPageUrl = next_page_url;
                    }
                } else {
                    state.searchProducts = state.searchProducts;
                }
                state.loadMore = false;
            }
        );
        builder.addCase(getMoreSearchProducts.rejected, (state) => {
            state.loadMore = false;
        });
    },
});

export const { resetSearchProduct } = searchProductsSlice.actions;
export default searchProductsSlice.reducer;
